import { api, APIError } from "encore.dev/api";
import { db } from "./db";

interface DeleteMadrasahRequest {
  id: string;
}

// Deletes a madrasah (superadmin only)
export const deleteMadrasah = api<DeleteMadrasahRequest, void>(
  { expose: true, method: "DELETE", path: "/madrasah/:id" },
  async (req) => {
    const { id } = req;
    
    // Check if madrasah exists
    const existing = await db.queryRow<{ id: string }>`
      SELECT id FROM madrasah WHERE id = ${id}
    `;
    
    if (!existing) {
      throw APIError.notFound("Madrasah not found");
    }
    
    // Delete madrasah (cascade will handle related records)
    await db.exec`DELETE FROM madrasah WHERE id = ${id}`;
  }
);
