import { api } from "encore.dev/api";
import { db } from "./db";

interface ResetTokenRequest {
  madrasah_id: string;
}

interface ResetTokenResponse {
  madrasah_id: string;
  new_token: string;
  message: string;
}

export const resetToken = api<ResetTokenRequest, ResetTokenResponse>(
  { expose: true, method: "POST", path: "/madrasah/:madrasah_id/reset-token" },
  async (req) => {
    const randomToken = Math.random().toString(36).substring(2, 10).toUpperCase();
    
    await db.exec`
      UPDATE madrasah 
      SET operator_token = ${randomToken},
          operator_password = NULL,
          operator_registered = FALSE
      WHERE id = ${req.madrasah_id}
    `;
    
    return {
      madrasah_id: req.madrasah_id,
      new_token: randomToken,
      message: "Token berhasil direset. Operator harus registrasi ulang dengan token baru."
    };
  }
);
