# ADAM API Documentation

Dokumentasi lengkap API untuk ADAM (Aplikasi Database Madrasah).

## Base URL

```
Production: https://your-domain.com/api
Development: http://localhost:4000/api
```

## Authentication

ADAM menggunakan token-based authentication.

### Login

```http
POST /auth/login
Content-Type: application/json

{
  "username": "string",
  "password": "string"
}
```

**Response:**
```json
{
  "token": "string",
  "userType": "madrasah" | "superadmin",
  "madrasahId": "string",
  "madrasahName": "string"
}
```

### Authentication Header

Untuk endpoint yang memerlukan autentikasi, sertakan token di header:

```http
Authorization: Bearer YOUR_TOKEN_HERE
```

## Error Responses

Semua error menggunakan format standar:

```json
{
  "code": "error_code",
  "message": "Human readable message",
  "details": {}
}
```

### Error Codes

- `not_found` (404): Resource tidak ditemukan
- `invalid_argument` (400): Input tidak valid
- `unauthenticated` (401): Token tidak valid atau expired
- `permission_denied` (403): Tidak memiliki akses
- `already_exists` (409): Resource sudah ada
- `internal` (500): Server error

## Endpoints

### Madrasah

#### List Madrasah (Super Admin Only)

```http
GET /madrasah?search=string&limit=number&offset=number
```

**Response:**
```json
{
  "madrasah": [
    {
      "id": "uuid",
      "nsm": "string",
      "npsn": "string",
      "nama_madrasah": "string",
      "alamat": "string",
      "kecamatan": "string",
      "kabupaten": "string",
      "provinsi": "string",
      "akreditasi": "string",
      "status": "string",
      "nama_kepala": "string"
    }
  ],
  "total": 0
}
```

#### Create Madrasah

```http
POST /madrasah
Content-Type: application/json

{
  "nsm": "string",
  "npsn": "string",
  "nama_madrasah": "string",
  "alamat": "string",
  "kecamatan": "string",
  "kabupaten": "string",
  "provinsi": "string",
  "akreditasi": "string",
  "status": "string",
  "nama_kepala": "string"
}
```

#### Update Madrasah

```http
PUT /madrasah/:id
Content-Type: application/json

{
  "nsm": "string",
  "npsn": "string",
  "nama_madrasah": "string",
  // ... other fields
}
```

#### Delete Madrasah

```http
DELETE /madrasah/:id
```

#### Import Madrasah

```http
POST /madrasah/import
Content-Type: application/json

{
  "data": [
    {
      "nsm": "string",
      "npsn": "string",
      "nama_madrasah": "string",
      // ... other fields
    }
  ]
}
```

**Response:**
```json
{
  "success": 0,
  "failed": 0,
  "errors": ["string"]
}
```

### Guru

#### List Guru

```http
GET /guru?madrasah_id=uuid&search=string&limit=number&offset=number
```

#### Create Guru

```http
POST /guru
Content-Type: application/json

{
  "madrasah_id": "uuid",
  "nip": "string",
  "nama_lengkap": "string",
  "tempat_lahir": "string",
  "tanggal_lahir": "YYYY-MM-DD",
  "jenis_kelamin": "string",
  "agama": "string",
  "alamat": "string",
  "no_telepon": "string",
  "email": "string",
  "pendidikan_terakhir": "string",
  "mata_pelajaran": "string",
  "status_kepegawaian": "string",
  "tanggal_masuk": "YYYY-MM-DD"
}
```

#### Import Guru

```http
POST /guru/import
Content-Type: application/json

{
  "madrasah_id": "uuid",
  "data": [
    {
      "nip": "string",
      "nama_lengkap": "string",
      // ... other fields
    }
  ]
}
```

### Siswa

#### List Siswa

```http
GET /siswa?madrasah_id=uuid&search=string&kelas=string&status=string&limit=number&offset=number
```

#### Create Siswa

```http
POST /siswa
Content-Type: application/json

{
  "madrasah_id": "uuid",
  "nisn": "string",
  "nis": "string",
  "nama_lengkap": "string",
  "tempat_lahir": "string",
  "tanggal_lahir": "YYYY-MM-DD",
  "jenis_kelamin": "string",
  "agama": "string",
  "alamat": "string",
  "no_telepon": "string",
  "nama_ayah": "string",
  "nama_ibu": "string",
  "pekerjaan_ayah": "string",
  "pekerjaan_ibu": "string",
  "kelas": "string",
  "tahun_masuk": 2024,
  "status": "aktif"
}
```

#### Import Siswa

```http
POST /siswa/import
Content-Type: application/json

{
  "madrasah_id": "uuid",
  "data": [
    {
      "nisn": "string",
      "nis": "string",
      "nama_lengkap": "string",
      // ... other fields
    }
  ]
}
```

### Karyawan

#### List Karyawan

```http
GET /karyawan?madrasah_id=uuid&search=string&bagian=string&limit=number&offset=number
```

#### Create Karyawan

```http
POST /karyawan
Content-Type: application/json

{
  "madrasah_id": "uuid",
  "nip": "string",
  "nama_lengkap": "string",
  "tempat_lahir": "string",
  "tanggal_lahir": "YYYY-MM-DD",
  "jenis_kelamin": "string",
  "agama": "string",
  "alamat": "string",
  "no_telepon": "string",
  "email": "string",
  "pendidikan_terakhir": "string",
  "jabatan": "string",
  "bagian": "string",
  "tanggal_masuk": "YYYY-MM-DD",
  "status_kepegawaian": "string"
}
```

#### Import Karyawan

```http
POST /karyawan/import
Content-Type: application/json

{
  "madrasah_id": "uuid",
  "data": [
    {
      "nip": "string",
      "nama_lengkap": "string",
      // ... other fields
    }
  ]
}
```

### Alumni

#### List Alumni

```http
GET /alumni?madrasah_id=uuid&search=string&tahun_lulus=number&limit=number&offset=number
```

#### Create Alumni

```http
POST /alumni
Content-Type: application/json

{
  "madrasah_id": "uuid",
  "nisn": "string",
  "nis": "string",
  "nama_lengkap": "string",
  "tempat_lahir": "string",
  "tanggal_lahir": "YYYY-MM-DD",
  "jenis_kelamin": "string",
  "agama": "string",
  "alamat": "string",
  "no_telepon": "string",
  "tahun_lulus": 2024,
  "melanjutkan_ke": "string",
  "pekerjaan": "string",
  "alamat_sekarang": "string"
}
```

#### Import Alumni

```http
POST /alumni/import
Content-Type: application/json

{
  "madrasah_id": "uuid",
  "data": [
    {
      "nisn": "string",
      "nis": "string",
      "nama_lengkap": "string",
      // ... other fields
    }
  ]
}
```

### Reports

#### Get Recap Data

```http
GET /reports/recap?madrasah_id=uuid
```

**Response:**
```json
{
  "data": [
    {
      "madrasah_id": "uuid",
      "nama_madrasah": "string",
      "total_guru": 0,
      "total_siswa": 0,
      "total_karyawan": 0,
      "total_alumni": 0
    }
  ],
  "grand_total": {
    "total_guru": 0,
    "total_siswa": 0,
    "total_karyawan": 0,
    "total_alumni": 0
  }
}
```

## Rate Limiting

API memiliki rate limiting untuk mencegah abuse:

- **General endpoints**: 100 requests per minute
- **Import endpoints**: 10 requests per minute
- **Authentication**: 5 requests per minute

## Pagination

Endpoints yang mengembalikan list data mendukung pagination:

```http
GET /endpoint?limit=50&offset=0
```

- `limit`: Jumlah maksimal data per halaman (default: 50, max: 100)
- `offset`: Jumlah data yang dilewati (default: 0)

## Search

Endpoints list mendukung pencarian:

```http
GET /endpoint?search=keyword
```

Search akan mencari di field yang relevan (nama, NIP, NISN, dll).

## Date Format

Semua tanggal menggunakan format ISO 8601:

- Input: `YYYY-MM-DD` (contoh: `2024-01-15`)
- Output: `YYYY-MM-DD` (contoh: `2024-01-15`)

## File Upload

Untuk import data, gunakan format JSON dengan array data:

```json
{
  "madrasah_id": "uuid",
  "data": [
    {
      "field1": "value1",
      "field2": "value2"
    }
  ]
}
```

## Examples

### JavaScript/TypeScript

```javascript
// Login
const response = await fetch('/api/auth/login', {
  method: 'POST',
  headers: {
    'Content-Type': 'application/json',
  },
  body: JSON.stringify({
    username: 'your_username',
    password: 'your_password'
  })
});

const { token } = await response.json();

// Authenticated request
const guruResponse = await fetch('/api/guru', {
  headers: {
    'Authorization': `Bearer ${token}`
  }
});

const guruData = await guruResponse.json();
```

### cURL

```bash
# Login
curl -X POST http://localhost:4000/api/auth/login \
  -H "Content-Type: application/json" \
  -d '{"username":"your_username","password":"your_password"}'

# Get data with token
curl -X GET http://localhost:4000/api/guru \
  -H "Authorization: Bearer YOUR_TOKEN"
```

## SDK

Untuk kemudahan development, gunakan auto-generated client:

```typescript
import backend from '~backend/client';

// Login
const loginResult = await backend.auth.login({
  username: 'your_username',
  password: 'your_password'
});

// Get data
const guruData = await backend.guru.listGuru({
  madrasah_id: 'uuid',
  search: 'keyword'
});
```

## Support

Untuk pertanyaan API:

1. Check dokumentasi ini
2. Review example code
3. Create issue di GitHub
4. Contact development team
